set linesize 200
/************************************************************************************#
#*                                                                                   #
#* Purpose: STATA program to create permanent .DTA data set                          #
#*          harmonzd_tus_cps_1992_through_2019_replicate_wgts_06_19_beta             #
#*          with the Harmonized TUS CPS 1992 through 2019 replicate weights 06-19    #
#*                                                                                   #
#*          The program does NOT use STATA dictionaries                              #
#*                                                                                   #
#*************************************************************************************/

/*****************************************************************************************
 Set working directory
 Input and output files are saved here
*****************************************************************************************/

cd "\\westat.com\DFS\NCIDCCPS\DCCPS - Global\Scientific Projects\TUS-CPS\Statistician\ifc\STATA work\prg\3. Harmonized data"

//*****************************************************************************************
// Create dictionary

file open dictionary  using ".\dictionary.dct", write replace
set more off

file write dictionary   /// 
"infile dictionary {" _n ///
"_column(1)"    _tab "int   " _tab "SurYear "   _tab "%4f   " _tab `""Survey year""' _n ///
"_column(5)"    _tab "int   " _tab "SurMonth"   _tab "%2f   " _tab `""Survey month""' _n ///
"_column(7)"    _tab "str22 " _tab "RecordID"   _tab "%22s  " _tab `""Record ID (Unique within survey month)""' _n ///
"_column(29)"   _tab "double" _tab "SmplWgt "   _tab "%11.4f" _tab `""Self Response Sample Weight""' _n ///
"_column(40)"   _tab "double" _tab "RepWt001"   _tab "%11.4f" _tab `""Replicate Weight #1""' _n ///
"_column(51)"   _tab "double" _tab "RepWt002"   _tab "%11.4f" _tab `""Replicate Weight #2""' _n ///
"_column(62)"   _tab "double" _tab "RepWt003"   _tab "%11.4f" _tab `""Replicate Weight #3""' _n ///
"_column(73)"   _tab "double" _tab "RepWt004"   _tab "%11.4f" _tab `""Replicate Weight #4""' _n ///
"_column(84)"   _tab "double" _tab "RepWt005"   _tab "%11.4f" _tab `""Replicate Weight #5""' _n ///
"_column(95)"   _tab "double" _tab "RepWt006"   _tab "%11.4f" _tab `""Replicate Weight #6""' _n ///
"_column(106)"  _tab "double" _tab "RepWt007"   _tab "%11.4f" _tab `""Replicate Weight #7""' _n ///
"_column(117)"  _tab "double" _tab "RepWt008"   _tab "%11.4f" _tab `""Replicate Weight #8""' _n ///
"_column(128)"  _tab "double" _tab "RepWt009"   _tab "%11.4f" _tab `""Replicate Weight #9""' _n ///
"_column(139)"  _tab "double" _tab "RepWt010"   _tab "%11.4f" _tab `""Replicate Weight #10""' _n ///
"_column(150)"  _tab "double" _tab "RepWt011"   _tab "%11.4f" _tab `""Replicate Weight #11""' _n ///
"_column(161)"  _tab "double" _tab "RepWt012"   _tab "%11.4f" _tab `""Replicate Weight #12""' _n ///
"_column(172)"  _tab "double" _tab "RepWt013"   _tab "%11.4f" _tab `""Replicate Weight #13""' _n ///
"_column(183)"  _tab "double" _tab "RepWt014"   _tab "%11.4f" _tab `""Replicate Weight #14""' _n ///
"_column(194)"  _tab "double" _tab "RepWt015"   _tab "%11.4f" _tab `""Replicate Weight #15""' _n ///
"_column(205)"  _tab "double" _tab "RepWt016"   _tab "%11.4f" _tab `""Replicate Weight #16""' _n ///
"_column(216)"  _tab "double" _tab "RepWt017"   _tab "%11.4f" _tab `""Replicate Weight #17""' _n ///
"_column(227)"  _tab "double" _tab "RepWt018"   _tab "%11.4f" _tab `""Replicate Weight #18""' _n ///
"_column(238)"  _tab "double" _tab "RepWt019"   _tab "%11.4f" _tab `""Replicate Weight #19""' _n ///
"_column(249)"  _tab "double" _tab "RepWt020"   _tab "%11.4f" _tab `""Replicate Weight #20""' _n ///
"_column(260)"  _tab "double" _tab "RepWt021"   _tab "%11.4f" _tab `""Replicate Weight #21""' _n ///
"_column(271)"  _tab "double" _tab "RepWt022"   _tab "%11.4f" _tab `""Replicate Weight #22""' _n ///
"_column(282)"  _tab "double" _tab "RepWt023"   _tab "%11.4f" _tab `""Replicate Weight #23""' _n ///
"_column(293)"  _tab "double" _tab "RepWt024"   _tab "%11.4f" _tab `""Replicate Weight #24""' _n ///
"_column(304)"  _tab "double" _tab "RepWt025"   _tab "%11.4f" _tab `""Replicate Weight #25""' _n ///
"_column(315)"  _tab "double" _tab "RepWt026"   _tab "%11.4f" _tab `""Replicate Weight #26""' _n ///
"_column(326)"  _tab "double" _tab "RepWt027"   _tab "%11.4f" _tab `""Replicate Weight #27""' _n ///
"_column(337)"  _tab "double" _tab "RepWt028"   _tab "%11.4f" _tab `""Replicate Weight #28""' _n ///
"_column(348)"  _tab "double" _tab "RepWt029"   _tab "%11.4f" _tab `""Replicate Weight #29""' _n ///
"_column(359)"  _tab "double" _tab "RepWt030"   _tab "%11.4f" _tab `""Replicate Weight #30""' _n ///
"_column(370)"  _tab "double" _tab "RepWt031"   _tab "%11.4f" _tab `""Replicate Weight #31""' _n ///
"_column(381)"  _tab "double" _tab "RepWt032"   _tab "%11.4f" _tab `""Replicate Weight #32""' _n ///
"_column(392)"  _tab "double" _tab "RepWt033"   _tab "%11.4f" _tab `""Replicate Weight #33""' _n ///
"_column(403)"  _tab "double" _tab "RepWt034"   _tab "%11.4f" _tab `""Replicate Weight #34""' _n ///
"_column(414)"  _tab "double" _tab "RepWt035"   _tab "%11.4f" _tab `""Replicate Weight #35""' _n ///
"_column(425)"  _tab "double" _tab "RepWt036"   _tab "%11.4f" _tab `""Replicate Weight #36""' _n ///
"_column(436)"  _tab "double" _tab "RepWt037"   _tab "%11.4f" _tab `""Replicate Weight #37""' _n ///
"_column(447)"  _tab "double" _tab "RepWt038"   _tab "%11.4f" _tab `""Replicate Weight #38""' _n ///
"_column(458)"  _tab "double" _tab "RepWt039"   _tab "%11.4f" _tab `""Replicate Weight #39""' _n ///
"_column(469)"  _tab "double" _tab "RepWt040"   _tab "%11.4f" _tab `""Replicate Weight #40""' _n ///
"_column(480)"  _tab "double" _tab "RepWt041"   _tab "%11.4f" _tab `""Replicate Weight #41""' _n ///
"_column(491)"  _tab "double" _tab "RepWt042"   _tab "%11.4f" _tab `""Replicate Weight #42""' _n ///
"_column(502)"  _tab "double" _tab "RepWt043"   _tab "%11.4f" _tab `""Replicate Weight #43""' _n ///
"_column(513)"  _tab "double" _tab "RepWt044"   _tab "%11.4f" _tab `""Replicate Weight #44""' _n ///
"_column(524)"  _tab "double" _tab "RepWt045"   _tab "%11.4f" _tab `""Replicate Weight #45""' _n ///
"_column(535)"  _tab "double" _tab "RepWt046"   _tab "%11.4f" _tab `""Replicate Weight #46""' _n ///
"_column(546)"  _tab "double" _tab "RepWt047"   _tab "%11.4f" _tab `""Replicate Weight #47""' _n ///
"_column(557)"  _tab "double" _tab "RepWt048"   _tab "%11.4f" _tab `""Replicate Weight #48""' _n ///
"_column(568)"  _tab "double" _tab "RepWt049"   _tab "%11.4f" _tab `""Replicate Weight #49""' _n ///
"_column(579)"  _tab "double" _tab "RepWt050"   _tab "%11.4f" _tab `""Replicate Weight #50""' _n ///
"_column(590)"  _tab "double" _tab "RepWt051"   _tab "%11.4f" _tab `""Replicate Weight #51""' _n ///
"_column(601)"  _tab "double" _tab "RepWt052"   _tab "%11.4f" _tab `""Replicate Weight #52""' _n ///
"_column(612)"  _tab "double" _tab "RepWt053"   _tab "%11.4f" _tab `""Replicate Weight #53""' _n ///
"_column(623)"  _tab "double" _tab "RepWt054"   _tab "%11.4f" _tab `""Replicate Weight #54""' _n ///
"_column(634)"  _tab "double" _tab "RepWt055"   _tab "%11.4f" _tab `""Replicate Weight #55""' _n ///
"_column(645)"  _tab "double" _tab "RepWt056"   _tab "%11.4f" _tab `""Replicate Weight #56""' _n ///
"_column(656)"  _tab "double" _tab "RepWt057"   _tab "%11.4f" _tab `""Replicate Weight #57""' _n ///
"_column(667)"  _tab "double" _tab "RepWt058"   _tab "%11.4f" _tab `""Replicate Weight #58""' _n ///
"_column(678)"  _tab "double" _tab "RepWt059"   _tab "%11.4f" _tab `""Replicate Weight #59""' _n ///
"_column(689)"  _tab "double" _tab "RepWt060"   _tab "%11.4f" _tab `""Replicate Weight #60""' _n ///
"_column(700)"  _tab "double" _tab "RepWt061"   _tab "%11.4f" _tab `""Replicate Weight #61""' _n ///
"_column(711)"  _tab "double" _tab "RepWt062"   _tab "%11.4f" _tab `""Replicate Weight #62""' _n ///
"_column(722)"  _tab "double" _tab "RepWt063"   _tab "%11.4f" _tab `""Replicate Weight #63""' _n ///
"_column(733)"  _tab "double" _tab "RepWt064"   _tab "%11.4f" _tab `""Replicate Weight #64""' _n ///
"_column(744)"  _tab "double" _tab "RepWt065"   _tab "%11.4f" _tab `""Replicate Weight #65""' _n ///
"_column(755)"  _tab "double" _tab "RepWt066"   _tab "%11.4f" _tab `""Replicate Weight #66""' _n ///
"_column(766)"  _tab "double" _tab "RepWt067"   _tab "%11.4f" _tab `""Replicate Weight #67""' _n ///
"_column(777)"  _tab "double" _tab "RepWt068"   _tab "%11.4f" _tab `""Replicate Weight #68""' _n ///
"_column(788)"  _tab "double" _tab "RepWt069"   _tab "%11.4f" _tab `""Replicate Weight #69""' _n ///
"_column(799)"  _tab "double" _tab "RepWt070"   _tab "%11.4f" _tab `""Replicate Weight #70""' _n ///
"_column(810)"  _tab "double" _tab "RepWt071"   _tab "%11.4f" _tab `""Replicate Weight #71""' _n ///
"_column(821)"  _tab "double" _tab "RepWt072"   _tab "%11.4f" _tab `""Replicate Weight #72""' _n ///
"_column(832)"  _tab "double" _tab "RepWt073"   _tab "%11.4f" _tab `""Replicate Weight #73""' _n ///
"_column(843)"  _tab "double" _tab "RepWt074"   _tab "%11.4f" _tab `""Replicate Weight #74""' _n ///
"_column(854)"  _tab "double" _tab "RepWt075"   _tab "%11.4f" _tab `""Replicate Weight #75""' _n ///
"_column(865)"  _tab "double" _tab "RepWt076"   _tab "%11.4f" _tab `""Replicate Weight #76""' _n ///
"_column(876)"  _tab "double" _tab "RepWt077"   _tab "%11.4f" _tab `""Replicate Weight #77""' _n ///
"_column(887)"  _tab "double" _tab "RepWt078"   _tab "%11.4f" _tab `""Replicate Weight #78""' _n ///
"_column(898)"  _tab "double" _tab "RepWt079"   _tab "%11.4f" _tab `""Replicate Weight #79""' _n ///
"_column(909)"  _tab "double" _tab "RepWt080"   _tab "%11.4f" _tab `""Replicate Weight #80""' _n ///
"_column(920)"  _tab "double" _tab "RepWt081"   _tab "%11.4f" _tab `""Replicate Weight #81""' _n ///
"_column(931)"  _tab "double" _tab "RepWt082"   _tab "%11.4f" _tab `""Replicate Weight #82""' _n ///
"_column(942)"  _tab "double" _tab "RepWt083"   _tab "%11.4f" _tab `""Replicate Weight #83""' _n ///
"_column(953)"  _tab "double" _tab "RepWt084"   _tab "%11.4f" _tab `""Replicate Weight #84""' _n ///
"_column(964)"  _tab "double" _tab "RepWt085"   _tab "%11.4f" _tab `""Replicate Weight #85""' _n ///
"_column(975)"  _tab "double" _tab "RepWt086"   _tab "%11.4f" _tab `""Replicate Weight #86""' _n ///
"_column(986)"  _tab "double" _tab "RepWt087"   _tab "%11.4f" _tab `""Replicate Weight #87""' _n ///
"_column(997)"  _tab "double" _tab "RepWt088"   _tab "%11.4f" _tab `""Replicate Weight #88""' _n ///
"_column(1008)" _tab "double" _tab "RepWt089"   _tab "%11.4f" _tab `""Replicate Weight #89""' _n ///
"_column(1019)" _tab "double" _tab "RepWt090"   _tab "%11.4f" _tab `""Replicate Weight #90""' _n ///
"_column(1030)" _tab "double" _tab "RepWt091"   _tab "%11.4f" _tab `""Replicate Weight #91""' _n ///
"_column(1041)" _tab "double" _tab "RepWt092"   _tab "%11.4f" _tab `""Replicate Weight #92""' _n ///
"_column(1052)" _tab "double" _tab "RepWt093"   _tab "%11.4f" _tab `""Replicate Weight #93""' _n ///
"_column(1063)" _tab "double" _tab "RepWt094"   _tab "%11.4f" _tab `""Replicate Weight #94""' _n ///
"_column(1074)" _tab "double" _tab "RepWt095"   _tab "%11.4f" _tab `""Replicate Weight #95""' _n ///
"_column(1085)" _tab "double" _tab "RepWt096"   _tab "%11.4f" _tab `""Replicate Weight #96""' _n ///
"_column(1096)" _tab "double" _tab "RepWt097"   _tab "%11.4f" _tab `""Replicate Weight #97""' _n ///
"_column(1107)" _tab "double" _tab "RepWt098"   _tab "%11.4f" _tab `""Replicate Weight #98""' _n ///
"_column(1118)" _tab "double" _tab "RepWt099"   _tab "%11.4f" _tab `""Replicate Weight #99""' _n ///
"_column(1129)" _tab "double" _tab "RepWt100"   _tab "%11.4f" _tab `""Replicate Weight #100""' _n ///
"_column(1140)" _tab "double" _tab "RepWt101"   _tab "%11.4f" _tab `""Replicate Weight #101""' _n ///
"_column(1151)" _tab "double" _tab "RepWt102"   _tab "%11.4f" _tab `""Replicate Weight #102""' _n ///
"_column(1162)" _tab "double" _tab "RepWt103"   _tab "%11.4f" _tab `""Replicate Weight #103""' _n ///
"_column(1173)" _tab "double" _tab "RepWt104"   _tab "%11.4f" _tab `""Replicate Weight #104""' _n ///
"_column(1184)" _tab "double" _tab "RepWt105"   _tab "%11.4f" _tab `""Replicate Weight #105""' _n ///
"_column(1195)" _tab "double" _tab "RepWt106"   _tab "%11.4f" _tab `""Replicate Weight #106""' _n ///
"_column(1206)" _tab "double" _tab "RepWt107"   _tab "%11.4f" _tab `""Replicate Weight #107""' _n ///
"_column(1217)" _tab "double" _tab "RepWt108"   _tab "%11.4f" _tab `""Replicate Weight #108""' _n ///
"_column(1228)" _tab "double" _tab "RepWt109"   _tab "%11.4f" _tab `""Replicate Weight #109""' _n ///
"_column(1239)" _tab "double" _tab "RepWt110"   _tab "%11.4f" _tab `""Replicate Weight #110""' _n ///
"_column(1250)" _tab "double" _tab "RepWt111"   _tab "%11.4f" _tab `""Replicate Weight #111""' _n ///
"_column(1261)" _tab "double" _tab "RepWt112"   _tab "%11.4f" _tab `""Replicate Weight #112""' _n ///
"_column(1272)" _tab "double" _tab "RepWt113"   _tab "%11.4f" _tab `""Replicate Weight #113""' _n ///
"_column(1283)" _tab "double" _tab "RepWt114"   _tab "%11.4f" _tab `""Replicate Weight #114""' _n ///
"_column(1294)" _tab "double" _tab "RepWt115"   _tab "%11.4f" _tab `""Replicate Weight #115""' _n ///
"_column(1305)" _tab "double" _tab "RepWt116"   _tab "%11.4f" _tab `""Replicate Weight #116""' _n ///
"_column(1316)" _tab "double" _tab "RepWt117"   _tab "%11.4f" _tab `""Replicate Weight #117""' _n ///
"_column(1327)" _tab "double" _tab "RepWt118"   _tab "%11.4f" _tab `""Replicate Weight #118""' _n ///
"_column(1338)" _tab "double" _tab "RepWt119"   _tab "%11.4f" _tab `""Replicate Weight #119""' _n ///
"_column(1349)" _tab "double" _tab "RepWt120"   _tab "%11.4f" _tab `""Replicate Weight #120""' _n ///
"_column(1360)" _tab "double" _tab "RepWt121"   _tab "%11.4f" _tab `""Replicate Weight #121""' _n ///
"_column(1371)" _tab "double" _tab "RepWt122"   _tab "%11.4f" _tab `""Replicate Weight #122""' _n ///
"_column(1382)" _tab "double" _tab "RepWt123"   _tab "%11.4f" _tab `""Replicate Weight #123""' _n ///
"_column(1393)" _tab "double" _tab "RepWt124"   _tab "%11.4f" _tab `""Replicate Weight #124""' _n ///
"_column(1404)" _tab "double" _tab "RepWt125"   _tab "%11.4f" _tab `""Replicate Weight #125""' _n ///
"_column(1415)" _tab "double" _tab "RepWt126"   _tab "%11.4f" _tab `""Replicate Weight #126""' _n ///
"_column(1426)" _tab "double" _tab "RepWt127"   _tab "%11.4f" _tab `""Replicate Weight #127""' _n ///
"_column(1437)" _tab "double" _tab "RepWt128"   _tab "%11.4f" _tab `""Replicate Weight #128""' _n ///
"_column(1448)" _tab "double" _tab "RepWt129"   _tab "%11.4f" _tab `""Replicate Weight #129""' _n ///
"_column(1459)" _tab "double" _tab "RepWt130"   _tab "%11.4f" _tab `""Replicate Weight #130""' _n ///
"_column(1470)" _tab "double" _tab "RepWt131"   _tab "%11.4f" _tab `""Replicate Weight #131""' _n ///
"_column(1481)" _tab "double" _tab "RepWt132"   _tab "%11.4f" _tab `""Replicate Weight #132""' _n ///
"_column(1492)" _tab "double" _tab "RepWt133"   _tab "%11.4f" _tab `""Replicate Weight #133""' _n ///
"_column(1503)" _tab "double" _tab "RepWt134"   _tab "%11.4f" _tab `""Replicate Weight #134""' _n ///
"_column(1514)" _tab "double" _tab "RepWt135"   _tab "%11.4f" _tab `""Replicate Weight #135""' _n ///
"_column(1525)" _tab "double" _tab "RepWt136"   _tab "%11.4f" _tab `""Replicate Weight #136""' _n ///
"_column(1536)" _tab "double" _tab "RepWt137"   _tab "%11.4f" _tab `""Replicate Weight #137""' _n ///
"_column(1547)" _tab "double" _tab "RepWt138"   _tab "%11.4f" _tab `""Replicate Weight #138""' _n ///
"_column(1558)" _tab "double" _tab "RepWt139"   _tab "%11.4f" _tab `""Replicate Weight #139""' _n ///
"_column(1569)" _tab "double" _tab "RepWt140"   _tab "%11.4f" _tab `""Replicate Weight #140""' _n ///
"_column(1580)" _tab "double" _tab "RepWt141"   _tab "%11.4f" _tab `""Replicate Weight #141""' _n ///
"_column(1591)" _tab "double" _tab "RepWt142"   _tab "%11.4f" _tab `""Replicate Weight #142""' _n ///
"_column(1602)" _tab "double" _tab "RepWt143"   _tab "%11.4f" _tab `""Replicate Weight #143""' _n ///
"_column(1613)" _tab "double" _tab "RepWt144"   _tab "%11.4f" _tab `""Replicate Weight #144""' _n ///
"_column(1624)" _tab "double" _tab "RepWt145"   _tab "%11.4f" _tab `""Replicate Weight #145""' _n ///
"_column(1635)" _tab "double" _tab "RepWt146"   _tab "%11.4f" _tab `""Replicate Weight #146""' _n ///
"_column(1646)" _tab "double" _tab "RepWt147"   _tab "%11.4f" _tab `""Replicate Weight #147""' _n ///
"_column(1657)" _tab "double" _tab "RepWt148"   _tab "%11.4f" _tab `""Replicate Weight #148""' _n ///
"_column(1668)" _tab "double" _tab "RepWt149"   _tab "%11.4f" _tab `""Replicate Weight #149""' _n ///
"_column(1679)" _tab "double" _tab "RepWt150"   _tab "%11.4f" _tab `""Replicate Weight #150""' _n ///
"_column(1690)" _tab "double" _tab "RepWt151"   _tab "%11.4f" _tab `""Replicate Weight #151""' _n ///
"_column(1701)" _tab "double" _tab "RepWt152"   _tab "%11.4f" _tab `""Replicate Weight #152""' _n ///
"_column(1712)" _tab "double" _tab "RepWt153"   _tab "%11.4f" _tab `""Replicate Weight #153""' _n ///
"_column(1723)" _tab "double" _tab "RepWt154"   _tab "%11.4f" _tab `""Replicate Weight #154""' _n ///
"_column(1734)" _tab "double" _tab "RepWt155"   _tab "%11.4f" _tab `""Replicate Weight #155""' _n ///
"_column(1745)" _tab "double" _tab "RepWt156"   _tab "%11.4f" _tab `""Replicate Weight #156""' _n ///
"_column(1756)" _tab "double" _tab "RepWt157"   _tab "%11.4f" _tab `""Replicate Weight #157""' _n ///
"_column(1767)" _tab "double" _tab "RepWt158"   _tab "%11.4f" _tab `""Replicate Weight #158""' _n ///
"_column(1778)" _tab "double" _tab "RepWt159"   _tab "%11.4f" _tab `""Replicate Weight #159""' _n ///
"_column(1789)" _tab "double" _tab "RepWt160"   _tab "%11.4f" _tab `""Replicate Weight #160""' _n ///
"}"
set more on
file close dictionary 

//*****************************************************************************************
// Read 1995 to 2003 replicate weights

quietly infile using dictionary.dct, using ("./harmonzd.tus_cps.1992.through.2019.replicate.wgts.06_19.dat") clear

describe
                                                   
save harmonzd_tus_cps_1992_through_2019_replicate_wgts_06_19_beta, replace

erase "dictionary.dct"
